/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.gui.widgets;

import fi.dy.masa.malilib.gui.GuiTextFieldGeneric;
import fi.dy.masa.malilib.gui.widgets.WidgetConfigOptionBase;
import fi.dy.masa.malilib.gui.widgets.WidgetListBase;
import fi.dy.masa.malilib.gui.wrappers.TextFieldWrapper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;

public abstract class WidgetListConfigOptionsBase<TYPE, WIDGET extends WidgetConfigOptionBase<TYPE>>
extends WidgetListBase<TYPE, WIDGET> {
    protected final List<TextFieldWrapper<? extends GuiTextFieldGeneric>> textFields = new ArrayList<TextFieldWrapper<? extends GuiTextFieldGeneric>>();
    protected boolean configsModified;
    protected int maxLabelWidth;
    protected int configWidth;

    public WidgetListConfigOptionsBase(int x, int y, int width, int height, int configWidth) {
        super(x, y, width, height, null);
        this.configWidth = configWidth;
        this.browserEntryHeight = 22;
    }

    @Override
    protected void reCreateListEntryWidgets() {
        this.applyPendingModifications();
        if (!this.configsModified) {
            this.wereConfigsModified();
        }
        this.textFields.clear();
        super.reCreateListEntryWidgets();
    }

    @Override
    public boolean onMouseClicked(class_11909 click, boolean doubleClick) {
        this.clearTextFieldFocus();
        return super.onMouseClicked(click, doubleClick);
    }

    @Override
    public boolean onKeyTyped(class_11908 input) {
        if (input.comp_4795() == 258) {
            return this.changeTextFieldFocus(input.method_74239());
        }
        for (WidgetConfigOptionBase widget : this.listWidgets) {
            if (!widget.onKeyTyped(input)) continue;
            return true;
        }
        return super.onKeyTyped(input);
    }

    @Override
    public boolean onCharTyped(class_11905 input) {
        for (WidgetConfigOptionBase widget : this.listWidgets) {
            if (!widget.onCharTyped(input)) continue;
            return true;
        }
        return super.onCharTyped(input);
    }

    public void addTextField(TextFieldWrapper<? extends GuiTextFieldGeneric> wrapper) {
        this.textFields.add(wrapper);
    }

    protected boolean changeTextFieldFocus(boolean reverse) {
        int size = this.textFields.size();
        if (size > 1) {
            int currentIndex = -1;
            for (int i = 0; i < size; ++i) {
                GuiTextFieldGeneric textField = this.textFields.get(i).getTextField();
                if (!textField.method_25370()) continue;
                currentIndex = i;
                textField.method_25365(false);
                break;
            }
            if (currentIndex != -1) {
                int newIndex = currentIndex + (reverse ? -1 : 1);
                if (newIndex >= size) {
                    newIndex = 0;
                } else if (newIndex < 0) {
                    newIndex = size - 1;
                }
                this.textFields.get(newIndex).getTextField().method_25365(true);
                this.applyPendingModifications();
                return true;
            }
        }
        return false;
    }

    protected void clearTextFieldFocus() {
        this.applyPendingModifications();
        for (int i = 0; i < this.textFields.size(); ++i) {
            GuiTextFieldGeneric textField = this.textFields.get(i).getTextField();
            if (!textField.method_25370()) continue;
            textField.method_25365(false);
            break;
        }
    }

    public void markConfigsModified() {
        this.configsModified = true;
    }

    public boolean wereConfigsModified() {
        if (this.configsModified) {
            return true;
        }
        for (WidgetConfigOptionBase widget : this.listWidgets) {
            if (!widget.wasConfigModified()) continue;
            this.configsModified = true;
            return true;
        }
        return false;
    }

    public void clearConfigsModifiedFlag() {
        this.configsModified = false;
    }

    public void applyPendingModifications() {
        for (WidgetConfigOptionBase widget : this.listWidgets) {
            if (!widget.hasPendingModifications()) continue;
            widget.applyNewValueToConfig();
            this.configsModified = true;
        }
    }
}

