/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.compile.tasks;

import net.caffeinemc.mods.sodium.client.render.chunk.RenderSection;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.BuilderTaskOutput;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.ChunkBuildContext;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.estimation.JobDurationEstimator;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.estimation.MeshTaskSizeEstimator;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.estimation.UploadDurationEstimator;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.CombinedCameraPos;
import net.caffeinemc.mods.sodium.client.util.task.CancellationToken;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public abstract class ChunkBuilderTask<OUTPUT extends BuilderTaskOutput>
implements CombinedCameraPos {
    protected final RenderSection render;
    protected final int submitTime;
    protected final Vector3dc absoluteCameraPos;
    protected final Vector3fc cameraPos;
    private long estimatedSize;
    private long estimatedDuration;
    private long estimatedUploadDuration;

    public ChunkBuilderTask(RenderSection render, int time, Vector3dc absoluteCameraPos) {
        this.render = render;
        this.submitTime = time;
        this.absoluteCameraPos = absoluteCameraPos;
        this.cameraPos = new Vector3f((float)(absoluteCameraPos.x() - (double)render.getOriginX()), (float)(absoluteCameraPos.y() - (double)render.getOriginY()), (float)(absoluteCameraPos.z() - (double)render.getOriginZ()));
    }

    public abstract OUTPUT execute(ChunkBuildContext var1, CancellationToken var2);

    public abstract long estimateTaskSizeWith(MeshTaskSizeEstimator var1);

    public void calculateEstimations(JobDurationEstimator jobEstimator, MeshTaskSizeEstimator sizeEstimator, UploadDurationEstimator uploadEstimator) {
        this.estimatedSize = this.estimateTaskSizeWith(sizeEstimator);
        this.estimatedDuration = jobEstimator.estimateJobDuration(this.getClass(), this.estimatedSize);
        this.estimatedUploadDuration = uploadEstimator.estimateUploadDuration(this.estimatedSize);
    }

    public long getEstimatedSize() {
        return this.estimatedSize;
    }

    public long getEstimatedDuration() {
        return this.estimatedDuration;
    }

    public long getEstimatedUploadDuration() {
        return this.estimatedUploadDuration;
    }

    @Override
    public Vector3fc getRelativeCameraPos() {
        return this.cameraPos;
    }

    @Override
    public Vector3dc getAbsoluteCameraPos() {
        return this.absoluteCameraPos;
    }
}

