/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective_common_neoforge.schematic;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective_common_neoforge.schematic.Schematic;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class ParsedSchematicObject {
    public Schematic schematic;
    public List<Pair<BlockPos, BlockState>> blocks;
    public List<Pair<BlockPos, Entity>> entities;
    public List<BlockPos> blockEntityPositions;
    public String parseMessageString;
    public boolean parsedCorrectly;
    public int offsetX;
    public int offsetY;
    public int offsetZ;

    public ParsedSchematicObject(Schematic _schematic, List<Pair<BlockPos, BlockState>> _blocks, List<Pair<BlockPos, Entity>> _entities, List<BlockPos> _blockEntityPositions, String _parseMessageString, boolean _parsedCorrectly) {
        this.schematic = _schematic;
        this.blocks = _blocks;
        this.entities = _entities;
        this.blockEntityPositions = _blockEntityPositions;
        this.parseMessageString = _parseMessageString;
        this.parsedCorrectly = _parsedCorrectly;
        this.offsetX = _schematic.getOffsetX();
        this.offsetY = _schematic.getOffsetY();
        this.offsetZ = _schematic.getOffsetZ();
    }

    public void placeBlockEntitiesInWorld(Level level) {
        List<CompoundTag> compoundTags = this.schematic.getBlockEntities();
        int i = 0;
        for (Pair<BlockPos, BlockEntity> pair : this.getBlockEntities(level)) {
            BlockPos pos = (BlockPos)pair.getFirst();
            CompoundTag compoundTag = compoundTags.get(i);
            compoundTag.remove("Pos");
            compoundTag.putString("id", compoundTag.getStringOr("Id", ""));
            BlockEntity blockEntity = BlockEntity.loadStatic((BlockPos)pos, (BlockState)level.getBlockState(pos), (CompoundTag)compoundTag, (HolderLookup.Provider)level.registryAccess());
            level.setBlockEntity(blockEntity);
            ++i;
        }
    }

    public List<Pair<BlockPos, BlockEntity>> getBlockEntities(Level level) {
        ArrayList<Pair<BlockPos, BlockEntity>> blockEntities = new ArrayList<Pair<BlockPos, BlockEntity>>();
        for (BlockPos pos : this.blockEntityPositions) {
            blockEntities.add((Pair<BlockPos, BlockEntity>)new Pair((Object)pos, (Object)level.getBlockEntity(pos)));
        }
        return blockEntities;
    }
}

