/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.simplerpc.discord;

import com.hypherionmc.craterlib.core.event.CraterEvent;
import com.hypherionmc.craterlib.core.event.CraterEventBus;
import com.hypherionmc.simplerpc.RPCConstants;
import com.hypherionmc.simplerpc.api.events.RPCEvents;
import com.hypherionmc.simplerpc.rpcsdk.enums.ErrorCode;
import com.hypherionmc.simplerpc.rpcsdk.handlers.RPCEventHandler;
import com.hypherionmc.simplerpc.rpcsdk.models.User;
import org.jetbrains.annotations.Nullable;

public final class SimpleRpcDiscordEventHandler
extends RPCEventHandler {
    @Override
    public void ready(User user) {
        RPCConstants.logger.info("Successfully connected to discord as {}", (Object)user.getUsername());
        CraterEventBus.INSTANCE.postEvent((CraterEvent)RPCEvents.Ready.of(user));
    }

    @Override
    public void disconnected(ErrorCode errorCode, @Nullable String s) {
        RPCConstants.logger.error("Disconnected from discord with error: {}, {}", (Object)errorCode.name(), (Object)s);
        CraterEventBus.INSTANCE.postEvent((CraterEvent)RPCEvents.Disconnected.of(errorCode, s));
    }

    @Override
    public void errored(ErrorCode errorCode, @Nullable String s) {
        RPCConstants.logger.error("Encountered an error communicating with discord: {}, {}", (Object)errorCode.name(), (Object)s);
        CraterEventBus.INSTANCE.postEvent((CraterEvent)RPCEvents.Errored.of(errorCode, s));
    }
}

